/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.entity.data.IEmotionPart;
import noppes.npcs.entity.EntityNPCInterface;

public class EmotionFrame
implements IEmotionPart {
    public static final EmotionFrame EMPTY = new EmotionFrame(0);
    public int id;
    public int speed = 20;
    public int delay = 0;
    public boolean smooth = true;
    public boolean disable = false;
    public boolean blink = false;
    public boolean endBlink = false;
    public float[] offsetEye = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public float[] rotEye = new float[]{0.0f, 0.0f};
    public float[] scaleEye = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public float[] offsetPupil = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public float[] rotPupil = new float[]{0.0f, 0.0f};
    public float[] scalePupil = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public float[] offsetBrow = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    public float[] rotBrow = new float[]{0.0f, 0.0f};
    public float[] scaleBrow = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public float[] offsetMouth = new float[]{0.0f, 0.0f};
    public float rotMouth = 0.0f;
    public float[] scaleMouth = new float[]{1.0f, 1.0f};
    public boolean rndMouth = false;
    public boolean showMouth = false;
    public EntityNPCInterface npc;

    public EmotionFrame(int id) {
        this.id = id;
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isEndBlink() {
        return this.endBlink;
    }

    @Override
    public void setBlink(boolean bo) {
        this.blink = bo;
    }

    @Override
    public void setEndBlink(boolean bo) {
        this.endBlink = bo;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_150296_c().isEmpty()) {
            return;
        }
        this.id = compound.func_74762_e("Part");
        this.setSpeed(compound.func_74762_e("Speed"));
        this.setEndDelay(compound.func_74762_e("EndDelay"));
        this.smooth = compound.func_74767_n("IsSmooth");
        this.disable = compound.func_74767_n("IsDisable");
        this.blink = compound.func_74767_n("IsBlink");
        this.endBlink = compound.func_74767_n("IsEndBlink");
        this.rndMouth = compound.func_74767_n("IsRandomMouth");
        this.showMouth = compound.func_74767_n("ShowMouth");
        this.rotMouth = compound.func_74760_g("RotationMouth");
        NBTTagList listRotEye = compound.func_150295_c("RotationEye", 5);
        NBTTagList listOffEye = compound.func_150295_c("OffsetEye", 5);
        NBTTagList listScEye = compound.func_150295_c("ScaleEye", 5);
        NBTTagList listRotBrow = compound.func_150295_c("RotationBrow", 5);
        NBTTagList listOffBrow = compound.func_150295_c("OffsetBrow", 5);
        NBTTagList listScBrow = compound.func_150295_c("ScaleBrow", 5);
        NBTTagList listRotPupil = compound.func_150295_c("RotationPupil", 5);
        NBTTagList listOffPupil = compound.func_150295_c("OffsetPupil", 5);
        NBTTagList listScPupil = compound.func_150295_c("ScalePupil", 5);
        NBTTagList listOffMouth = compound.func_150295_c("OffsetMouth", 5);
        NBTTagList listScMouth = compound.func_150295_c("ScaleMouth", 5);
        int max = listRotEye.func_74745_c();
        if (max < listOffEye.func_74745_c()) {
            max = listOffEye.func_74745_c();
        }
        if (max < listScEye.func_74745_c()) {
            max = listScEye.func_74745_c();
        }
        if (max < this.rotEye.length) {
            max = this.rotEye.length;
        }
        if (max < this.offsetEye.length) {
            max = this.offsetEye.length;
        }
        if (max < this.scaleEye.length) {
            max = this.scaleEye.length;
        }
        for (int i = 0; i < max; ++i) {
            if (i < this.rotEye.length && i < listRotEye.func_74745_c()) {
                this.rotEye[i] = listRotEye.func_150308_e(i);
            }
            if (i < this.offsetEye.length && i < listOffEye.func_74745_c()) {
                this.offsetEye[i] = listOffEye.func_150308_e(i);
            }
            if (i < this.scaleEye.length && i < listScEye.func_74745_c()) {
                this.scaleEye[i] = listScEye.func_150308_e(i);
            }
            if (i < this.rotBrow.length && i < listRotBrow.func_74745_c()) {
                this.rotBrow[i] = listRotBrow.func_150308_e(i);
            }
            if (i < this.offsetBrow.length && i < listOffBrow.func_74745_c()) {
                this.offsetBrow[i] = listOffBrow.func_150308_e(i);
            }
            if (i < this.scaleBrow.length && i < listScBrow.func_74745_c()) {
                this.scaleBrow[i] = listScBrow.func_150308_e(i);
            }
            if (i < this.rotPupil.length && i < listRotPupil.func_74745_c()) {
                this.rotPupil[i] = listRotPupil.func_150308_e(i);
            }
            if (i < this.offsetPupil.length && i < listOffPupil.func_74745_c()) {
                this.offsetPupil[i] = listOffPupil.func_150308_e(i);
            }
            if (i < this.scalePupil.length && i < listScPupil.func_74745_c()) {
                this.scalePupil[i] = listScPupil.func_150308_e(i);
            }
            if (i < this.offsetMouth.length && i < listOffMouth.func_74745_c()) {
                this.offsetMouth[i] = listOffMouth.func_150308_e(i);
            }
            if (i >= this.scaleMouth.length || i >= listScMouth.func_74745_c()) continue;
            this.scaleMouth[i] = listScMouth.func_150308_e(i);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = this.getCompound();
        NBTTagList listRotEye = new NBTTagList();
        NBTTagList listOffEye = new NBTTagList();
        NBTTagList listScEye = new NBTTagList();
        NBTTagList listRotBrow = new NBTTagList();
        NBTTagList listOffBrow = new NBTTagList();
        NBTTagList listScBrow = new NBTTagList();
        NBTTagList listRotPupil = new NBTTagList();
        NBTTagList listOffPupil = new NBTTagList();
        NBTTagList listScPupil = new NBTTagList();
        NBTTagList listRotMouth = new NBTTagList();
        NBTTagList listOffMouth = new NBTTagList();
        NBTTagList listScMouth = new NBTTagList();
        int max = this.rotEye.length;
        if (max < this.offsetEye.length) {
            max = this.offsetEye.length;
        }
        if (max < this.scaleEye.length) {
            max = this.scaleEye.length;
        }
        for (int i = 0; i < max; ++i) {
            if (i < this.rotEye.length) {
                listRotEye.func_74742_a((NBTBase)new NBTTagFloat(this.rotEye[i]));
            }
            if (i < this.offsetEye.length) {
                listOffEye.func_74742_a((NBTBase)new NBTTagFloat(this.offsetEye[i]));
            }
            if (i < this.scaleEye.length) {
                listScEye.func_74742_a((NBTBase)new NBTTagFloat(this.scaleEye[i]));
            }
            if (i < this.rotBrow.length) {
                listRotBrow.func_74742_a((NBTBase)new NBTTagFloat(this.rotBrow[i]));
            }
            if (i < this.offsetBrow.length) {
                listOffBrow.func_74742_a((NBTBase)new NBTTagFloat(this.offsetBrow[i]));
            }
            if (i < this.scaleBrow.length) {
                listScBrow.func_74742_a((NBTBase)new NBTTagFloat(this.scaleBrow[i]));
            }
            if (i < this.rotPupil.length) {
                listRotPupil.func_74742_a((NBTBase)new NBTTagFloat(this.rotPupil[i]));
            }
            if (i < this.offsetPupil.length) {
                listOffPupil.func_74742_a((NBTBase)new NBTTagFloat(this.offsetPupil[i]));
            }
            if (i < this.scalePupil.length) {
                listScPupil.func_74742_a((NBTBase)new NBTTagFloat(this.scalePupil[i]));
            }
            if (i < this.offsetMouth.length) {
                listOffMouth.func_74742_a((NBTBase)new NBTTagFloat(this.offsetMouth[i]));
            }
            if (i >= this.scaleMouth.length) continue;
            listScMouth.func_74742_a((NBTBase)new NBTTagFloat(this.scaleMouth[i]));
        }
        compound.func_74782_a("RotationEye", (NBTBase)listRotEye);
        compound.func_74782_a("OffsetEye", (NBTBase)listOffEye);
        compound.func_74782_a("ScaleEye", (NBTBase)listScEye);
        compound.func_74782_a("RotationBrow", (NBTBase)listRotBrow);
        compound.func_74782_a("OffsetBrow", (NBTBase)listOffBrow);
        compound.func_74782_a("ScaleBrow", (NBTBase)listScBrow);
        compound.func_74782_a("RotationPupil", (NBTBase)listRotPupil);
        compound.func_74782_a("OffsetPupil", (NBTBase)listOffPupil);
        compound.func_74782_a("ScalePupil", (NBTBase)listScPupil);
        compound.func_74782_a("RotationMouth", (NBTBase)listRotMouth);
        compound.func_74782_a("OffsetMouth", (NBTBase)listOffMouth);
        compound.func_74782_a("ScaleMouth", (NBTBase)listScMouth);
        return compound;
    }

    private NBTTagCompound getCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("Part", this.id);
        compound.func_74768_a("Speed", this.speed);
        compound.func_74768_a("EndDelay", this.delay);
        compound.func_74757_a("IsSmooth", this.smooth);
        compound.func_74757_a("IsDisable", this.disable);
        compound.func_74757_a("IsBlink", this.blink);
        compound.func_74757_a("IsEndBlink", this.endBlink);
        compound.func_74757_a("IsRandomMouth", this.rndMouth);
        compound.func_74757_a("ShowMouth", this.showMouth);
        compound.func_74776_a("RotationMouth", this.rotMouth);
        return compound;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public int getEndDelay() {
        return this.delay;
    }

    @Override
    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public void setEndDelay(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks > 1200) {
            ticks = 1200;
        }
        this.delay = ticks;
    }

    @Override
    public void setSmooth(boolean isSmooth) {
        this.smooth = isSmooth;
    }

    @Override
    public void setSpeed(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks > 1200) {
            ticks = 1200;
        }
        this.speed = ticks;
    }

    @Override
    public boolean isDisabled() {
        return this.disable;
    }

    @Override
    public void setDisable(boolean bo) {
        this.disable = bo;
    }

    public EmotionFrame copy() {
        EmotionFrame newEf = new EmotionFrame(0);
        newEf.readFromNBT(this.writeToNBT());
        return newEf;
    }

    public void clear() {
        this.speed = 20;
        this.delay = 0;
        this.smooth = true;
        this.disable = false;
        this.blink = false;
        this.endBlink = false;
        this.offsetEye = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.rotEye = new float[]{0.0f, 0.0f};
        this.scaleEye = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.offsetPupil = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.rotPupil = new float[]{0.0f, 0.0f};
        this.scalePupil = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.offsetBrow = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.rotBrow = new float[]{0.0f, 0.0f};
        this.scaleBrow = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.offsetMouth = new float[]{0.0f, 0.0f};
        this.rotMouth = 0.0f;
        this.scaleMouth = new float[]{1.0f, 1.0f};
        this.rndMouth = false;
        this.showMouth = false;
    }

    public void resetFrom(Map<Integer, Float[]> rotationAngles, EmotionFrame currentFrame) {
        Float[] pupilLeft;
        this.speed = currentFrame.speed;
        this.smooth = currentFrame.smooth;
        this.disable = currentFrame.disable;
        this.blink = currentFrame.blink;
        this.rotMouth = currentFrame.rotMouth;
        this.rndMouth = currentFrame.rndMouth;
        this.showMouth = currentFrame.showMouth;
        Float[] eyeRight = rotationAngles.get(0);
        this.offsetEye[0] = eyeRight[0].floatValue();
        this.offsetEye[1] = eyeRight[1].floatValue();
        this.scaleEye[0] = eyeRight[2].floatValue();
        this.scaleEye[1] = eyeRight[3].floatValue();
        this.rotEye[0] = eyeRight[4].floatValue();
        Float[] eyeLeft = rotationAngles.get(1);
        this.offsetEye[2] = eyeLeft[0].floatValue();
        this.offsetEye[3] = eyeLeft[1].floatValue();
        this.scaleEye[2] = eyeLeft[2].floatValue();
        this.scaleEye[3] = eyeLeft[3].floatValue();
        this.rotEye[1] = eyeLeft[4].floatValue();
        Float[] pupilRight = rotationAngles.get(2);
        if (pupilRight != null) {
            this.offsetPupil[0] = pupilRight[0].floatValue();
            this.offsetPupil[1] = pupilRight[1].floatValue();
            this.scalePupil[0] = pupilRight[2].floatValue();
            this.scalePupil[1] = pupilRight[3].floatValue();
            this.rotPupil[0] = pupilRight[4].floatValue();
        }
        if ((pupilLeft = rotationAngles.get(3)) != null) {
            this.offsetPupil[2] = pupilLeft[0].floatValue();
            this.offsetPupil[3] = pupilLeft[1].floatValue();
            this.scalePupil[2] = pupilLeft[2].floatValue();
            this.scalePupil[3] = pupilLeft[3].floatValue();
            this.rotPupil[1] = pupilLeft[4].floatValue();
        }
        Float[] browRight = rotationAngles.get(4);
        this.offsetBrow[0] = browRight[0].floatValue();
        this.offsetBrow[1] = browRight[1].floatValue();
        this.scaleBrow[0] = browRight[2].floatValue();
        this.scaleBrow[1] = browRight[3].floatValue();
        this.rotBrow[0] = browRight[4].floatValue();
        Float[] browLeft = rotationAngles.get(5);
        this.offsetBrow[2] = browLeft[0].floatValue();
        this.offsetBrow[3] = browLeft[1].floatValue();
        this.scaleBrow[2] = browLeft[2].floatValue();
        this.scaleBrow[3] = browLeft[3].floatValue();
        this.rotBrow[1] = browLeft[4].floatValue();
        Float[] mouth = rotationAngles.get(6);
        this.offsetMouth[0] = mouth[0].floatValue();
        this.offsetMouth[1] = mouth[1].floatValue();
        this.scaleMouth[0] = mouth[2].floatValue();
        this.scaleMouth[1] = mouth[3].floatValue();
        this.rotMouth = mouth[4].floatValue();
    }
}

